<?php
	$meta = get_post_meta( get_the_ID(), 'enjoyvideo_post_options', true );
	$duration = isset($meta['opt-duration']) ? $meta['opt-duration'] : '';
?>

<div id="post-<?php the_ID(); ?>" <?php post_class( 'ht_grid_1_4' ); ?>>	

	<?php if ( has_post_thumbnail() && ( blackvideo_option('loop-featured-on', true) == true) ) { ?>
		<a class="thumbnail-link" href="<?php the_permalink(); ?>">
			<div class="thumbnail-wrap">
				<?php 
					the_post_thumbnail('blackvideo_post_thumb'); 
				?>
			</div><!-- .thumbnail-wrap -->

			<?php if ( ( !empty($duration) ) && ( blackvideo_option('loop-duration-on', true) == true ) ){ ?>
				<div class="video-duration">
					<?php echo $duration; ?>
				</div><!-- .video-duration -->
			<?php } ?>	
			
			<?php if( (blackvideo_has_embed_code() || blackvideo_has_embed()) && ( blackvideo_option('loop-play-on', false) == true ) ) { ?>
				<div class="icon-play"><i class="genericon genericon-play"></i></div>
			<?php } ?>
		</a>
	<?php } ?>	

	<div class="entry-header">

		<?php if ( (!is_category()) && (!is_single()) && ( blackvideo_option('loop-category-on', true) == true ) ) : ?>
			<div class="entry-category"><?php blackvideo_first_category(); ?></div>
		<?php endif; ?>

		<h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>

		<div class="entry-meta">

			<?php if ( blackvideo_option('loop-views-on', true) == true ) { ?>

				<span class="entry-views"><?php echo blackvideo_get_post_views(get_the_ID()); ?></span>

			<?php } ?>

			<?php if ( (blackvideo_option('loop-views-on', true) == true) && (blackvideo_option('loop-date-on', true) == true) ) { ?>

				<span class="sep"> &middot; </span>
				
			<?php } ?>

			<?php if ( blackvideo_option('loop-date-on', true) == true ) { ?>

				<span class="entry-date">
					<?php
						if ( blackvideo_option('post-date-format', 'relative') == 'relative' ) {
							echo esc_html( human_time_diff(get_the_time('U'), current_time('timestamp')) ) . ' '.  esc_html( 'ago', 'blackvideo-pro' ); 
						} else {
							echo get_the_date();
						}
						?>
					</span>

			<?php } ?>

		</div><!-- .entry-meta -->		
									
	</div><!-- .entry-header -->

</div><!-- #post-<?php the_ID(); ?> -->