<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package blackvideo
 */	
?>

<?php
	$meta = get_post_meta( get_the_ID(), 'enjoyvideo_post_options', true );
	$video_code = isset($meta['opt-video-code']) ? $meta['opt-video-code'] : '';
	$duration = isset($meta['opt-duration']) ? $meta['opt-duration'] : '';
	$related_on = isset($meta['opt-related-on']) ? $meta['opt-related-on'] : true;
	$related_position = isset($meta['opt-related-position']) ? $meta['opt-related-position'] : 'sidebar';
	$single_related_position = isset($meta['opt-related-position']) ? $meta['opt-related-position'] : 'sidebar';
	$site_related_position = blackvideo_option('related-posts-position', 'sidebar');

	if ($single_related_position == 'sidebar') {
		$related_position = $site_related_position;
	} else {
		$related_position = $single_related_position;
	}	

	// Retrieve the value of old video embed code, e.g. "wpzoom_post_embed_code"
	if ( blackvideo_option('old-embed-code') ) {
		$old_embed_code = get_post_meta( get_the_ID(), blackvideo_option('old-embed-code'), true );
	} else {
		$old_embed_code = '';		
	}

	// If "wpzoom_post_embed_code" exists, use it for $video_code
	if ( ! empty( $old_embed_code ) ) {
	  $video_code = $old_embed_code;
	}

?>

<article id="post-<?php the_ID(); ?>" <?php if( ( (blackvideo_has_embed_code() || blackvideo_has_embed()) && (empty($video_code)) ) ) { post_class('has-embed'); } else { post_class(); }; ?>>

	<?php if (!empty($video_code)) { ?>	
		<div class="video-code">
			<?php echo $video_code; ?>
		</div><!-- .video-code -->
	<?php } ?>
	
	<header class="entry-header <?php if ( !empty($video_code) ) { echo 'has-video-code'; } ?> ">

		<?php
		if ( is_single() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;

		if ( 'post' === get_post_type() ) : ?>

		<?php get_template_part( 'template-parts/entry', 'meta' ); ?>

		<?php
		endif; ?>

	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
			
			if ( blackvideo_option('single-top-ad-on',true) && blackvideo_option('single-top-ad-code') ) {
				echo '<div class="single-top-ad">' . blackvideo_option('single-top-ad-code') . '</div>';
			}

			the_content( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'blackvideo-pro' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'blackvideo-pro' ),
				'after'  => '</div>',
			) );
		?>

		<div class="entry-footer">

			<?php
				edit_post_link(
					sprintf(
						/* translators: %s: Name of current post */
						esc_html__( 'Edit %s', 'blackvideo-pro' ),
						the_title( '<span class="screen-reader-text">"', '"</span>', false )
					),
					'<span class="edit-link">',
					'</span>'
				);
			?>
		</div><!-- .entry-tags -->

	</div><!-- .entry-content -->

	<div class="entry-meta-bottom clear">

		<?php if ( ( blackvideo_option('single-author-avatar-on', true) == true) || ( blackvideo_option('single-author-name-on', true) == true) || ( blackvideo_option('single-author-count-on', true) == true)): ?>
			<span class="entry-author">
				<?php if ( blackvideo_option('single-author-avatar-on', true) == true) : ?>
					<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'ID' ), 120 ); ?></a>
				<?php endif; ?>
				<?php if ( blackvideo_option('single-author-name-on', true) == true) : ?>
					<span class="author-name"><?php the_author_posts_link(); ?></span>
				<?php endif; ?>
				<?php if ( blackvideo_option('single-author-count-on', true) == true) : ?>
					<span class="author-posts"><?php printf( __( '%s Videos', 'blackvideo-pro' ), count_user_posts( get_the_author_meta( 'ID' ) ) ); ?></span>
				<?php endif; ?>
			</span>
		<?php endif; ?>

		<?php if ( blackvideo_option('single-category-on', true) == true) : ?>
			<span class="entry-category"><?php the_category(' '); ?></span>
		<?php endif; ?>

		<?php if ( blackvideo_option('single-tags-on', true) == true) : ?>
			<span class="entry-tags">
				<?php if (has_tag()) { ?><span class="tag-links"><?php the_tags(' ', ' '); ?></span><?php } ?>
			</span><!-- .entry-tags -->
		<?php endif; ?>

	</div><!-- .entry-meta-bottom -->

	<?php 
		if ( blackvideo_option('single-bottom-ad-on',true) && blackvideo_option('single-bottom-ad-code') ) {
			echo '<div class="single-bottom-ad">' . blackvideo_option('single-bottom-ad-code') . '</div>';
		}
	?>
	
</article><!-- #post-## -->

<?php if ( (blackvideo_option('single-related-on', true) == true) && ($related_on == true) && ($related_position == 'post-bottom') ) { ?>

<?php
	// Get the taxonomy terms of the current page for the specified taxonomy.
	$terms = wp_get_post_terms( get_the_ID(), 'category', array( 'fields' => 'ids' ) );

	// Bail if the term empty.
	if ( empty( $terms ) ) {
		return;
	}

	// Posts query arguments.
	if (blackvideo_option('related-type', 'category') == 'tag') { 

		$post_tag = get_the_tags ( $post->ID );
		// Define an empty array
		$ids = array();
		// Check if the post has any tags
		if ( $post_tag ) {
		    foreach ( $post_tag as $tag ) {
		        $ids[] = $tag->term_id; 
		    }
		}

		$query = array(
			'post__not_in' => array( get_the_ID() ),
		    'post_type' => 'post',
		    'tag__in'   => $ids,
		   	'posts_per_page' => blackvideo_option('post-bottom-related-num', 8), 
		);

	} else {

		$query = array(
			'post__not_in' => array( get_the_ID() ),
			'tax_query'    => array(
				array(
					'taxonomy' => 'category',
					'field'    => 'id',
					'terms'    => $terms,
					'operator' => 'IN'
				)
			),
			'posts_per_page' => blackvideo_option('post-bottom-related-num', 8), 
			'post_type'      => 'post',
		);

	}
	
	// Allow dev to filter the query.
	$args = apply_filters( 'blackvideo_related_posts_args', $query );

	// The post query
	$related = new WP_Query( $args );

	if ( $related->have_posts() ) : ?>

		<div class="post-bottom-related content-loop clear">

			<h3><?php echo blackvideo_option('single-related-title', 'You may be interested in'); ?></h3>

			<div class="related-loop clear">

			<?php while ( $related->have_posts() ) : $related->the_post(); ?>

				<?php get_template_part('template-parts/content', 'loop'); ?>

			<?php endwhile; ?>

			</div><!-- .related-loop -->

		</div><!-- .post-bottom-related -->

	<?php 
		endif;
		// Restore original Post Data.
		wp_reset_postdata();
	}
?>
