
<?php
	$meta = get_post_meta( get_the_ID(), 'enjoyvideo_post_options', true );
	$duration = isset($meta['opt-duration']) ? $meta['opt-duration'] : '';
	$related_on = isset($meta['opt-related-on']) ? $meta['opt-related-on'] : true;
	$related_position = isset($meta['opt-related-position']) ? $meta['opt-related-position'] : 'sidebar';
	$single_related_position = isset($meta['opt-related-position']) ? $meta['opt-related-position'] : 'sidebar';
	$site_related_position = blackvideo_option('related-posts-position', 'sidebar');

	if ($single_related_position == 'sidebar') {
		$related_position = $site_related_position;
	} else {
		$related_position = $single_related_position;
	}	
?>
<?php if ( is_single() && ( blackvideo_option('single-related-on', true) == true) && ($related_on == true) && ($related_position == 'site-bottom') ) { ?>

<?php
	// Get the taxonomy terms of the current page for the specified taxonomy.
	$terms = wp_get_post_terms( get_the_ID(), 'category', array( 'fields' => 'ids' ) );

	// Bail if the term empty.
	if ( empty( $terms ) ) {
		return;
	}

	// Posts query arguments.
	if (blackvideo_option('related-type', 'category') == 'tag') { 

		$post_tag = get_the_tags ( $post->ID );
		// Define an empty array
		$ids = array();
		// Check if the post has any tags
		if ( $post_tag ) {
		    foreach ( $post_tag as $tag ) {
		        $ids[] = $tag->term_id; 
		    }
		}

		$query = array(
			'post__not_in' => array( get_the_ID() ),
		    'post_type' => 'post',
		    'tag__in'   => $ids,
		   	'posts_per_page' => blackvideo_option('site-bottom-related-num', 8), 
		);

	} else {

		$query = array(
			'post__not_in' => array( get_the_ID() ),
			'tax_query'    => array(
				array(
					'taxonomy' => 'category',
					'field'    => 'id',
					'terms'    => $terms,
					'operator' => 'IN'
				)
			),
			'posts_per_page' => blackvideo_option('site-bottom-related-num', 8), 
			'post_type'      => 'post',
		);

	}

	// Allow dev to filter the query.
	$args = apply_filters( 'blackvideo_related_posts_args', $query );

	// The post query
	$related = new WP_Query( $args );

	if ( $related->have_posts() ) : ?>

		<div class="single-related-wrap">

		<div class="post-bottom-related clear">

			<h3><?php echo blackvideo_option('single-related-title', 'You may be interested in'); ?></h3>

			<div class="content-loop clear">

			<?php while ( $related->have_posts() ) : $related->the_post(); ?>

				<?php get_template_part('template-parts/content', 'loop'); ?>

			<?php endwhile; ?>

			</div><!-- .related-loop -->

		</div><!-- .post-bottom-related -->

		</div><!-- .single-wrap -->

	<?php 
		endif;
		// Restore original Post Data.
		wp_reset_postdata();
		}
	?>

<div id="site-bottom" class="clear">

	<?php 
		if ( has_nav_menu( 'footer' ) ) {
			wp_nav_menu( array( 'theme_location' => 'footer', 'menu_id' => 'footer-menu', 'menu_class' => 'footer-nav' ) );
		}
	?>	

	<div class="site-info">
		<?php
			echo blackvideo_option('footer-credit');
		?>
	</div><!-- .site-info -->

</div><!-- #site-bottom -->		