<?php
/**
 * Easy Digital Downloads Theme Updater
 *
 * @package EDD Sample Theme
 */

// Includes the files needed for the theme updater
if ( !class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include( dirname( __FILE__ ) . '/theme-updater-admin.php' );
}

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(

	// Config settings
	$config = array(
		'remote_api_url' => 'https://wpenjoy.com', // Site where EDD is hosted
		'item_name'      => 'BlackVideo Pro', // Name of theme
		'theme_slug'     => 'blackvideo-pro', // Theme slug
		'version'        => '1.0.4', // The current version of this theme
		'author'         => 'WPEnjoy', // The author of this theme
		'download_id'    => '', // Optional, used for generating a license renewal link
		'renew_url'      => '', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
		'item_id'        => '',
	),

	// Strings
	$strings = array(
		'theme-license'             => __( 'Theme License', 'blackvideo-pro' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'blackvideo-pro' ),
		'license-key'               => __( 'License Key', 'blackvideo-pro' ),
		'license-action'            => __( 'License Action', 'blackvideo-pro' ),
		'deactivate-license'        => __( 'Deactivate License', 'blackvideo-pro' ),
		'activate-license'          => __( 'Activate License', 'blackvideo-pro' ),
		'status-unknown'            => __( 'License status is unknown.', 'blackvideo-pro' ),
		'renew'                     => __( 'Renew?', 'blackvideo-pro' ),
		'unlimited'                 => __( 'unlimited', 'blackvideo-pro' ),
		'license-key-is-active'     => __( 'License key is active.', 'blackvideo-pro' ),
		'expires%s'                 => __( 'Expires %s.', 'blackvideo-pro' ),
		'expires-never'             => __( 'Lifetime License.', 'blackvideo-pro' ),
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'blackvideo-pro' ),
		'license-key-expired-%s'    => __( 'License key expired %s.', 'blackvideo-pro' ),
		'license-key-expired'       => __( 'License key has expired.', 'blackvideo-pro' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'blackvideo-pro' ),
		'license-is-inactive'       => __( 'License is inactive.', 'blackvideo-pro' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'blackvideo-pro' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'blackvideo-pro' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'blackvideo-pro' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'blackvideo-pro' ),
		'update-available'          => __('<strong>%1$s %2$s</strong> is available. <a href="%3$s" class="thickbox" title="%4s">Check out what\'s new</a> or <a href="%5$s"%6$s>update now</a>.', 'blackvideo-pro' ),
	)

);
