<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

//
// Set a unique slug-like ID
//
$prefix = 'blackvideo_option';

//
// Create options
//
CSF::createOptions( $prefix, array(
  'menu_title'          => 'Theme Options',
  'menu_slug'           => 'theme-options',
  'framework_title'     => 'BlackVideo Pro Theme Options',
  'show_search'         => false,
  'show_bar_menu'           => false,
  // framework title
  'theme'                   => 'light',
  'show_in_customizer'      => true,
  'show_sub_menu'           => false,
  'show_all_options'        => true,
  'sticky_header'           => false,
  'enqueue_webfont'         => true,
  'show_reset_section'      => false,
  'footer_credit'           => '&nbsp;',

) );


//
// Create a section
//
CSF::createSection( $prefix, array(
  'id'     => 'general',
  'title'  => 'General',
  'icon'   => 'fas fa-cog',
  'fields' => array(

    array(
      'type'    => 'content',
      'title'   => 'Site Logo',      
      'content' => 'Set Logo in '.'<a href="'. get_dashboard_url() .'customize.php">' . 'Site Identity' . '</a>',
    ),
    
    array(
      'id'      => 'site-layout',
      'type'    => 'radio',
      'title'   => 'Site Layout',
      'options' => array(
        'yes'   => 'Responsive Layout',
        'no'    => 'Fixed Layout',
      ),
      'default' => 'yes',
    ), 

    array(
      'id'    => 'admin-bar-on',
      'type'  => 'switcher',
      'title' => 'WordPress Admin Bar',
      'default' => true,
    ),       

    array(
      'id'    => 'header-search-on',
      'type'  => 'switcher',
      'title' => 'Header Search',
      'default' => true,
    ),

    array(
      'id'    => 'hide-sidebar-on',
      'type'  => 'switcher',
      'title' => 'Hide sidebar on mobile devices',
      'default' => false,
    ),

    array(
      'id'       => 'tag-cloud-num',
      'subtitle' => 'Max tags num',      
      'type'     => 'number',
      'title'    => 'Tag Cloud Widget',
      'default'  => '15',
    ),

    array(
      'id'       => 'old-embed-code',
      'subtitle' => 'Useful for migrating videos from other video themes',      
      'type'     => 'text',
      'title'    => 'Custom Field ID for Existing Video Embed Code',
      'default'  => '',
    ),    

  )
) );

//
// Create a section
//
CSF::createSection( $prefix, array(
  'id'     => 'color',
  'title'  => 'Colors',
  'icon'   => 'fas fa-paint-brush',
  'fields' => array(

    array(
      'id'      => 'primary-color',
      'type'    => 'color',
      'title'   => 'Primary Color',
      'default' => '#0abf53'
    ),         

  )
) );

//
// Create a section
//
CSF::createSection( $prefix, array(
  'id'     => 'typography',
  'title'  => 'Typography',
  'icon'   => 'fas fa-font',
  'fields' => array(

    array(
      'id'    => 'body-font',
      'type'  => 'typography',
      'title' => 'Body Font',
      'output'  => 'body,input,button,textarea,select',
      'text_align'     => false,
      'text_transform' => false,
      'letter_spacing' => false,
      'subset'         => false,
      'color'          => false,      
      'default'          => array(
        'font-family'    => 'Inter',
        'font-weight'    => '400',
        'type'           => 'google',        
        'font-size'      => '16',
        'line-height'    => '23',
        'unit'           => 'px'
      ),
    ),

    array(
      'id'    => 'heading-font',
      'type'  => 'typography',
      'title' => 'General Heading Font',
      'output'  => array('h1','h2','h3','h4','h5','h6'),
      'text_align'     => false,
      'text_transform' => false,
      'font_size'      => false,
      'line_height'    => false,
      'letter_spacing' => false,
      'color'          => false,
      'subset'         => false,
      'default'          => array(
        'font-family'    => 'Inter',
        'font-weight'    => '700',
        'type'           => 'google',        
        
      ),
    ),     

    array(
      'id'    => 'post-title-font',
      'type'  => 'typography',
      'title' => 'Post Title Font',
      'output'  => array('.content-loop .hentry .entry-title', '.content-block-1 .hentry .entry-title'),
      'text_align'     => false,
      'text_transform' => false,
      'font_size'      => false,
      'line_height'    => false,
      'letter_spacing' => false,
      'color'          => false,
      'subset'         => false,
      'default'          => array(
        'font-family'    => 'Inter',
        'font-weight'    => '400',
        'type'           => 'google',        
        
      ),
    ),  

  )
) );

//
// Create a section
//
CSF::createSection( $prefix, array(
  'id'     => 'home',
  'title'  => 'Homepage',
  'description' => 'To setup content blocks for homepage, please add widgets to the <strong>Home Content</strong> area. <a target="_blank" href="'. get_dashboard_url() .'widgets.php">Add Now</a>',  
  'icon'   => 'fas fa-desktop',
  'fields' => array(

    array(
      'id'    => 'post-border-radius',
      'type'  => 'number',
      'title' => 'Post Thumbnail Border Radius',
      'default' => '10',
    ),
  )
) );

//
// Create a section
//
CSF::createSection( $prefix, array(
  'id'     => 'archives',
  'title'  => 'Archive Page',
  'icon'   => 'fas fa-bars',
  'fields' => array(

    array(
      'id'    => 'category-desc-on',
      'type'  => 'switcher',
      'title' => 'Category Description',
      'default' => true,
    ),

    array(
      'id'    => 'loop-breadcrumbs-on',
      'type'  => 'switcher',
      'title' => 'Archive Breadcrumbs',
      'default' => true,
    ),

    array(
      'id'    => 'loop-featured-on',
      'type'  => 'switcher',
      'title' => 'Post Thumbnail',
      'default' => true,
    ),

    array(
      'id'    => 'loop-duration-on',
      'type'  => 'switcher',
      'title' => 'Video Duration',
      'default' => true,
    ),

    array(
      'id'    => 'loop-play-on',
      'type'  => 'switcher',
      'title' => 'Video Play Icon',
      'default' => false,
    ),

    array(
      'id'    => 'loop-category-on',
      'type'  => 'switcher',
      'title' => 'Post Category',
      'default' => true,
    ),

    array(
      'id'    => 'loop-views-on',
      'type'  => 'switcher',
      'title' => 'Post Views',
      'default' => true,
    ),     

    array(
      'id'    => 'loop-date-on',
      'type'  => 'switcher',
      'title' => 'Post Date',
      'default' => true,
    ),       

    array(
      'id'      => 'post-date-format',
      'type'    => 'radio',
      'title'   => 'Post Date Format',
      'options' => array(
        'relative'   => 'Relative Date',
        'default'    => 'WordPress Default',
      ),
      'default' => 'relative',
    ), 

  )
) );

//
// Create a section
//
CSF::createSection( $prefix, array(
  'id'     => 'single',
  'title'  => 'Single Post',
  'icon'   => 'far fa-file-alt',
  'fields' => array(

    array(
      'id'    => 'single-category-on',
      'type'  => 'switcher',
      'title' => 'Post Categories',
      'default' => true,
    ),

    array(
      'id'    => 'single-tag-on',
      'type'  => 'switcher',
      'title' => 'Post Tags',
      'default' => true,
    ),

    array(
      'id'    => 'single-author-avatar-on',
      'type'  => 'switcher',
      'title' => 'Post Author Avatar',
      'default' => true,
    ),

    array(
      'id'    => 'single-author-name-on',
      'type'  => 'switcher',
      'title' => 'Post Author Name',
      'default' => true,
    ),

    array(
      'id'    => 'single-author-count-on',
      'type'  => 'switcher',
      'title' => 'Post Author Posts Count',
      'default' => true,
    ),

    array(
      'id'    => 'single-views-on',
      'type'  => 'switcher',
      'title' => 'Post Views',
      'default' => true,
    ),   

    array(
      'id'    => 'single-date-on',
      'type'  => 'switcher',
      'title' => 'Post Date',
      'default' => true,
    ),

    array(
      'id'    => 'single-ratings-on',
      'type'  => 'switcher',
      'title' => 'Post Ratings (Thumbs Up/Down)',
      'default' => true,
    ),   

    array(
      'id'    => 'single-share-on',
      'type'  => 'switcher',
      'title' => 'Social Share Icons',
      'default' => true,
    ),      

    array(
      'id'    => 'single-related-on',
      'type'  => 'switcher',
      'title' => 'Related Posts',
      'default' => true,
    ),   

    array(
      'id'    => 'single-related-title',
      'type'  => 'text',
      'title' => 'Related Posts Heading',
      'default' => 'You may be interested in',
    ),   

    array(
      'id'      => 'related-type',
      'type'    => 'radio',
      'title'   => 'Query Related Posts by',
      'options' => array(
        'category'   => 'Category',
        'tag'    => 'Tags',
      ),
      'default' => 'category',
    ), 

    array(
      'id'      => 'related-posts-position',
      'type'    => 'radio',
      'title'   => 'Related Posts Position',
      'options' => array(
        'sidebar'   => 'Sidebar',
        'post-bottom'    => 'Post Bottom',
        'site-bottom'    => 'Site Bottom (full width)',        
      ),
      'default' => 'sidebar',
    ), 

    array(
      'id'       => 'related-num',
      'type'     => 'number',
      'title'    => 'Number of Related Posts (Sidebar)',
      'default'  => '10'
    ),

    array(
      'id'       => 'post-bottom-related-num',
      'type'     => 'number',
      'title'    => 'Number of Related Posts (Post Bottom)',
      'default'  => '8'
    ),

    array(
      'id'       => 'site-bottom-related-num',
      'type'     => 'number',
      'title'    => 'Number of Related Posts (Site Bottom)',
      'default'  => '8'
    ),        

  )
) );

//
// Create a section
//
CSF::createSection( $prefix, array(
  'id'     => 'footer',
  'title'  => 'Site Bottom',
  'icon'   => 'far fa-copyright',
  'fields' => array(

    array(
      'id'       => 'footer-credit',
      'type'     => 'wp_editor',
      'title'    => 'Copyright Info',
      'media_buttons' => false,
      'default'  => '&copy; ' . date("o") . ' <a href="' . home_url() .'">' . get_bloginfo('name') . '</a> - Theme by <a href="http://wpenjoy.com" target="_blank">WPEnjoy</a>',
    ),

  )

) );

CSF::createSection( $prefix, array(
  'id'     => 'ad',
  'title'  => 'Advertisement',
  'icon'   => 'fas fa-ad',
  'fields' => array(

    array(
      'type'    => 'subheading',
      'content' => 'Post Top Ad',
    ),

    array(
      'id'    => 'single-top-ad-on',
      'type'  => 'switcher',
      'title' => 'Display Ad',
      'default' => true,
    ),

    array(
      'id'       => 'single-top-ad-code',
      'type'     => 'code_editor',
      'title'    => 'Ad Code',
      'sanitize' => false,
    ),

    array(
      'type'    => 'subheading',
      'content' => 'Post Bottom Ad',
    ),

    array(
      'id'    => 'single-bottom-ad-on',
      'type'  => 'switcher',
      'title' => 'Display Ad',
      'default' => true,
    ),    

    array(
      'id'       => 'single-bottom-ad-code',
      'type'     => 'code_editor',
      'title'    => 'Ad Code',
      'sanitize' => false,
    ),

  )
) );


//
// Create a section
//

CSF::createSection( $prefix, array(
  'id'     => 'code',
  'title'  => 'Custom Code',
  'icon'   => 'fas fa-code',
  'fields' => array(

    array(
      'id'       => 'header-code',
      'type'     => 'code_editor',
      'title'    => 'Header Code',
      'subtitle' => 'Code will be added inside the &lt;head&gt; tag',
      'sanitize' => false,
    ),

    array(
      'id'       => 'footer-code',
      'type'     => 'code_editor',
      'title'    => 'Footer Code',
      'subtitle' => 'Code will be added inside the &lt;/body&gt; tag',
      'sanitize' => false,
    ),

  )
) );

//
// Create a section
//
CSF::createSection( $prefix, array(
  'id'     => 'backup',
  'title'  => 'Backup',
  'icon'   => 'fas fa-sync',
  'fields' => array(

    array(
      'type' => 'backup',
    ),

  )
) );