<?php
/**
 * Functions to provide support for the One Click Demo Import plugin (wordpress.org/plugins/one-click-demo-import)
 *
 * @package blackvideo
 */
function ocdi_import_files() {
  return [
    [
      'import_file_name'           => 'BlackVideo Pro',
      'import_file_url'            => get_template_directory_uri() . '/demo-content/demo-content.xml',
      'import_widget_file_url'     => get_template_directory_uri() . '/demo-content/demo-widgets.wie',
      'import_customizer_file_url' => get_template_directory_uri() . '/demo-content/demo-customizer.dat',
      'import_preview_image_url'   => get_template_directory_uri() . '/screenshot.png',
      'preview_url'                => 'https://demo.wpenjoy.com/blackvideo-pro',
    ],

  ];
}
add_filter( 'ocdi/import_files', 'ocdi_import_files' );

function ocdi_after_import_setup() {
    // Assign menus to their locations.
    $primary_menu = get_term_by( 'name', 'Top Menu', 'nav_menu' );
    $left_menu = get_term_by( 'name', 'Left Menu', 'nav_menu' );
    $posts_top_menu = get_term_by( 'name', 'Posts Top Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', [
            'primary' => $primary_menu->term_id, 
            'left'    => $left_menu->term_id, 
            'posts-top'    => $posts_top_menu->term_id,                                     
            'footer'  => $primary_menu->term_id, 
            'mobile'  => $left_menu->term_id, 
        ]
    );
 
    // Assign front page and posts page (blog page).
    //$front_page_id = get_page_by_title( 'Home' );
    //$blog_page_id  = get_page_by_title( 'Blog' );
 
    //update_option( 'show_on_front', 'page' );
    //update_option( 'page_on_front', $front_page_id->ID );
    //update_option( 'page_for_posts', $blog_page_id->ID );
 
}
add_action( 'ocdi/after_import', 'ocdi_after_import_setup' );