<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package blackvideo-pro
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="HandheldFriendly" content="true">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php wp_head(); ?>

<style type="text/css">
	/* Theme Styles */
	a,
	a:visited,
	a:hover,	
	.sf-menu ul li li a:hover,
	.sf-menu li.sfHover li a:hover,
	#primary-menu li li a:hover,
	.entry-meta a,
	.edit-link a,
	.comment-reply-title small a:hover,
	.single .entry-author .author-name a:hover,
	.entry-content a,
	.entry-content a:visited,
	.page-content a,
	.page-content a:visited,
	.pagination .page-numbers.current,
	.mobile-menu ul li a:hover,
	.pagination .page-numbers:hover,	
	.sidebar .widget a:hover,
	.sidebar .widget ul li a:hover,
	.entry-related .hentry .entry-title a:hover,
	.pld-like-dislike-wrap .pld-undo-trigger i,
	#site-bottom .site-info a:hover,
	#site-bottom .footer-nav li a:hover,
	.bypostauthor > article .fn:before,
	.comment-author a {
		color: <?php echo blackvideo_option('primary-color','#0abf53'); ?>;
	}
	#left-menu li li a:hover {
		color: <?php echo blackvideo_option('primary-color','#0abf53'); ?> !important;
	}
	button,
	.btn,
	input[type="submit"],
	input[type="reset"],
	input[type="button"],
	.header-search .search-submit,
	.single article .entry-category a:hover,
	.single article .entry-tags .tag-links a:hover,
	.widget_tag_cloud .tagcloud a:hover,
	#back-top a span,
	.content-block .section-heading .section-more-link a:hover,
	#primary-bar,
	.site-footer .widget_tag_cloud .tagcloud a:hover,
	.pagination .prev.page-numbers, 
	.pagination .next.page-numbers {
		background-color: <?php echo blackvideo_option('primary-color','#0abf53'); ?>;
	}
	.content-block .section-heading h3,
	.content-block .section-heading .section-more-link a,
	.content-block .section-heading .section-more-link a:visited,
	.breadcrumbs h1,
	.sidebar .widget .widget-title span,
	.comment-reply-title,
	.post-bottom-related h3,
	.comments-title {
		border-color: <?php echo blackvideo_option('primary-color','#0abf53'); ?>;
	}	
	#primary-menu li.current-menu-item a, 
	#primary-menu li.sfHover a,
	#primary-menu li a:hover {
		border-bottom-color: <?php echo blackvideo_option('primary-color','#0abf53'); ?>;
	}

    <?php if ( blackvideo_option('hide-sidebar-on',false) == true): ?>
	    @media only screen and (max-width: 479px) {
	    	#secondary {
	    		display: none !important;
	    	}	
	    }
	<?php endif; ?>

	.content-loop .thumbnail-link img {
		border-radius: <?php echo blackvideo_option('post-border-radius','10'); ?>px;
	}
</style>

<?php echo blackvideo_option('header-code'); ?>
</head>

<body <?php body_class(); ?>>

<?php
	//wp_body_open hook from WordPress 5.2
	if ( function_exists( 'wp_body_open' ) ) {
	    wp_body_open();
	} else { 
	    do_action( 'wp_body_open' ); 
	}
?>

<?php 
	if ( has_nav_menu( 'top' ) ) {
		echo '<div class="top-menu container clear">';
			wp_nav_menu( array( 'theme_location' => 'top', 'menu_id' => 'top-menu', 'menu_class' => 'sf-menu' ) );
		echo '</div>';
	}
?>

<div id="page" class="site">

	<a class="skip-link screen-reader-text" href="#content"><?php echo esc_html( 'Skip to content', 'blackvideo-pro' ); ?></a>

	<header id="masthead" class="site-header clear">

		<div class="site-start clear">

			<?php
				the_custom_header_markup();
			?>

			<div class="site-branding">

				<?php if ( has_custom_logo() ) { ?>

					<div id="logo">
						<?php the_custom_logo(); ?>
					</div><!-- #logo -->

				<?php } ?>

				<?php if (display_header_text()==true) { ?>

					<div class="site-title-desc">

						<div class="site-title">
							<h1><a href="<?php echo esc_url( home_url() ); ?>"><?php bloginfo('name'); ?></a></h1>
						</div><!-- .site-title -->	

						<div class="site-description">
							<?php bloginfo('description'); ?>
						</div><!-- .site-desc -->

					</div><!-- .site-title-desc -->

				<?php } ?>

			</div><!-- .site-branding -->	

			<?php if ( blackvideo_option('header-search-on', true) == true ) : ?> 
			<div class="header-search <?php if ( !has_nav_menu( 'primary' ) ) { echo 'no-top-menu'; } ?>">
				<form id="searchform" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<input type="search" name="s" class="search-input" placeholder="<?php esc_attr_e('Search', 'blackvideo-pro'); ?>" autocomplete="off">
					<button type="submit" class="search-submit"><span class="genericon genericon-search"></span></button>		
				</form>
			</div><!-- .header-search -->
			<?php endif; ?>
			
			<nav id="primary-nav" class="primary-navigation">

				<?php 
					if ( has_nav_menu( 'primary' ) ) {
						wp_nav_menu( array( 'theme_location' => 'primary', 'menu_id' => 'primary-menu', 'menu_class' => 'sf-menu' ) );
					}
				?>

			</nav><!-- #primary-nav -->		

			<div class="header-toggles">
				<button class="toggle nav-toggle mobile-nav-toggle" data-toggle-target=".menu-modal"  data-toggle-body-class="showing-menu-modal" aria-expanded="false" data-set-focus=".close-nav-toggle">
					<span class="toggle-inner">
						<span class="toggle-icon">
							<?php blackvideo_the_theme_svg( 'ellipsis' ); ?>
						</span>
						<span class="toggle-text"><?php esc_html_e( 'Menu', 'blackvideo-pro' ); ?></span>
					</span>
				</button><!-- .nav-toggle -->
			</div><!-- .header-toggles -->	

			<?php if ( blackvideo_option('header-search-on', true) ) : ?>
				
				<span class="search-icon">
					<span class="genericon genericon-search"></span>
					<span class="genericon genericon-close"></span>			
				</span>

			<?php endif; ?>	

		</div><!-- .site-start -->			

	</header><!-- #masthead -->

	<div class="menu-modal cover-modal header-footer-group" data-modal-target-string=".menu-modal">

		<div class="menu-modal-inner modal-inner">

			<div class="menu-wrapper section-inner">

				<div class="menu-top">

					<button class="toggle close-nav-toggle fill-children-current-color" data-toggle-target=".menu-modal" data-toggle-body-class="showing-menu-modal" aria-expanded="false" data-set-focus=".menu-modal">
						<span class="toggle-text"><?php esc_html_e( 'Close Menu', 'blackvideo-pro' ); ?></span>
						<?php blackvideo_the_theme_svg( 'cross' ); ?>
					</button><!-- .nav-toggle -->

					<?php

					$mobile_menu_location = '';

					// If the mobile menu location is not set, use the secondary location as fallbacks, in that order.
					if ( has_nav_menu( 'mobile' ) ) {
						$mobile_menu_location = 'mobile';
					} elseif ( has_nav_menu( 'left' ) ) {
						$mobile_menu_location = 'left';
					}

					?>

					<nav class="mobile-menu" aria-label="<?php esc_attr_e( 'Mobile', 'blackvideo-pro' ); ?>" role="navigation">

						<ul class="modal-menu reset-list-style">

						<?php
						if ( $mobile_menu_location ) {

							wp_nav_menu(
								array(
									'container'      => '',
									'items_wrap'     => '%3$s',
									'show_toggles'   => true,
									'theme_location' => $mobile_menu_location,
								)
							);

						} else {

							wp_list_pages(
								array(
									'match_menu_classes' => true,
									'show_toggles'       => true,
									'title_li'           => false,
									'walker'             => new BlackVideo_Walker_Page(),
								)
							);

						}
						?>

						</ul>

					</nav>

				</div><!-- .menu-top -->

			</div><!-- .menu-wrapper -->

		</div><!-- .menu-modal-inner -->

	</div><!-- .menu-modal -->		
		
	<div id="content" class="site-content <?php if ( is_active_sidebar( 'home' ) ) { echo 'has-home-widget'; } else { 'no-home-widget'; } ?> container">

		<div class="clear">
