<?php

// Customize transport postMessage variable to set `postMessage` or `refresh` as required.
$customizer_selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';

$options = apply_filters(
	'colormag_top_bar_options',
	array(
		'colormag_top_bar_title'                => array(
			'type'         => 'customind-accordion',
			'title'        => esc_html__( 'Top Bar', 'colormag' ),
			'section'      => 'colormag_top_bar_section',
			'priority'     => 5,
			'sub_controls' => apply_filters(
				'colormag_top_bar_sub_controls',
				array(
					'colormag_top_bar_general_heading'     => array(
						'type'    => 'customind-title',
						'title'   => esc_html__( 'General', 'colormag' ),
						'section' => 'colormag_top_bar_section',
					),
					'colormag_enable_top_bar'              => array(
						'title'   => esc_html__( 'Enable', 'colormag' ),
						'default' => false,
						'type'    => 'customind-toggle',
						'section' => 'colormag_top_bar_section',
					),
					'colormag_top_bar_full_width'          => array(
						'title'     => esc_html__( 'Full Width', 'colormag' ),
						'default'   => 0,
						'type'      => 'customind-toggle',
						'section'   => 'colormag_top_bar_section',
						'condition' => array(
							'colormag_enable_top_bar' => true,
						),
					),
					'colormag_top_bar_style_heading_divider' => array(
						'type'      => 'customind-divider',
						'variant'   => 'dashed',
						'section'   => 'colormag_top_bar_section',
						'condition' => array(
							'colormag_enable_top_bar' => true,
						),
					),
					'colormag_top_bar_style_heading'       => array(
						'type'      => 'customind-title',
						'title'     => esc_html__( 'Style', 'colormag' ),
						'section'   => 'colormag_top_bar_section',
						'condition' => array(
							'colormag_enable_top_bar' => true,
						),
					),
					'colormag_top_bar_background_color'    => array(
						'title'     => esc_html__( 'Background', 'colormag' ),
						'default'   => '#fff',
						'type'      => 'customind-color',
						'transport' => 'postMessage',
						'section'   => 'colormag_top_bar_section',
						'condition' => array(
							'colormag_enable_top_bar' => true,
						),
					),
					'colormag_top_bar_border_bottom_size'  => array(
						'default'     => array(
							'size' => '',
							'unit' => 'px',
						),
						'type'        => 'customind-slider',
						'title'       => esc_html__( 'Border Bottom Size', 'colormag' ),
						'section'     => 'colormag_top_bar_section',
						'transport'   => 'postMessage',
						'units'       => array( 'px' ),
						'defaultUnit' => 'px',
						'input_attrs' => array(
							'min'  => 0,
							'max'  => 20,
							'step' => 1,
						),
						'condition'   => array(
							'colormag_enable_top_bar' => true,
						),
					),
					'colormag_top_bar_border_bottom_color' => array(
						'default'   => '',
						'type'      => 'customind-color',
						'title'     => esc_html__( 'Border Bottom Color', 'colormag' ),
						'transport' => 'postMessage',
						'section'   => 'colormag_top_bar_section',
						'condition' => array(
							'colormag_enable_top_bar' => true,
						),
					),
				)
			),
			'collapsible'  => apply_filters( 'colormag_top_bar_accordion_collapsible', false ),
		),
		'colormag_display_date_heading'         => array(
			'type'         => 'customind-accordion',
			'title'        => esc_html__( 'Date', 'colormag' ),
			'section'      => 'colormag_top_bar_section',
			'sub_controls' => apply_filters(
				'colormag_display_date_sub_controls',
				array(
					'colormag_date_display'      => array(
						'title'     => esc_html__( 'Enable', 'colormag' ),
						'default'   => false,
						'type'      => 'customind-toggle',
						'section'   => 'colormag_top_bar_section',
						'transport' => $customizer_selective_refresh,
						'partial'   => array(
							'selector'        => '.date-in-header',
							'render_callback' => array(
								'ColorMag_Customizer_Partials',
								'render_current_date',
							),
						),
					),
					'colormag_date_display_type' => array(
						'default'   => 'theme_default',
						'type'      => 'customind-select',
						'title'     => esc_html__( 'Date Format', 'colormag' ),
						'section'   => 'colormag_top_bar_section',
						'choices'   => array(
							'theme_default'          => esc_html__( 'Theme Default Setting', 'colormag' ),
							'wordpress_date_setting' => esc_html__( 'From WordPress Date Setting', 'colormag' ),
						),
						'condition' => array(
							'colormag_date_display' => true,
						),
						'partial'   => array(
							'selector'        => '.date-in-header',
							'render_callback' => array(
								'ColorMag_Customizer_Partials',
								'render_date_display_type',
							),
						),
					),
				)
			),
			'collapsible'  => apply_filters( 'colormag_display_date_accordion_collapsible', false ),
			'condition'    => array(
				'colormag_enable_top_bar' => true,
			),
		),
		'colormag_top_bar_news_ticker_title'    => array(
			'type'         => 'customind-accordion',
			'title'        => esc_html__( 'News Ticker', 'colormag' ),
			'section'      => 'colormag_top_bar_section',
			'sub_controls' => apply_filters(
				'colormag_top_bar_news_ticker_sub_controls',
				array(
					'colormag_news_ticker_navigate' => array(
						'title'    => esc_html__( 'News Ticker', 'colormag' ),
						'type'     => 'customind-navigation',
						'section'  => 'colormag_top_bar_section',
						'to'       => 'colormag_news_ticker_section',
						'nav_type' => 'section',
					),
				)
			),
			'collapsible'  => apply_filters( 'colormag_top_bar_news_ticker_accordion_collapsible', false ),
			'condition'    => array(
				'colormag_enable_top_bar' => true,
			),
		),
		'colormag_top_bar_social_icons_heading' => array(
			'type'         => 'customind-accordion',
			'title'        => esc_html__( 'Social Icons', 'colormag' ),
			'section'      => 'colormag_top_bar_section',
			'sub_controls' => apply_filters(
				'colormag_top_bar_social_icons_sub_controls',
				array(
					'colormag_top_bar_social_icons_navigate' => array(
						'title'    => esc_html__( 'Social Icons', 'colormag' ),
						'type'     => 'customind-navigation',
						'section'  => 'colormag_top_bar_section',
						'to'       => 'colormag_social_icons_section',
						'nav_type' => 'section',
					),
				)
			),
			'collapsible'  => apply_filters( 'colormag_top_bar_social_icons_accordion_collapsible', false ),
			'condition'    => array(
				'colormag_enable_top_bar' => true,
			),
		),
		'colormag_top_bar_menu_heading'         => array(
			'type'         => 'customind-accordion',
			'title'        => esc_html__( 'Menu', 'colormag' ),
			'section'      => 'colormag_top_bar_section',
			'sub_controls' => apply_filters(
				'colormag_top_bar_menu_sub_controls',
				array(
					'colormag_top_bar_menu_enable' => array(
						'title'   => esc_html__( 'Enable', 'colormag' ),
						'default' => false,
						'type'    => 'customind-toggle',
						'section' => 'colormag_top_bar_section',
					),
					'colormag_top_bar_menu'        => array(
						'title'     => esc_html__( 'Menus', 'colormag' ),
						'type'      => 'customind-navigation',
						'section'   => 'colormag_top_bar_section',
						'to'        => 'add_menu',
						'nav_type'  => 'section',
						'condition' => array(
							'colormag_top_bar_menu_enable' => true,
						),
					),
				)
			),
			'collapsible'  => apply_filters( 'colormag_top_bar_menu_accordion_collapsible', false ),
			'condition'    => array(
				'colormag_enable_top_bar' => true,
			),
		),
		'colormag_top_bar_text_heading'         => array(
			'type'         => 'customind-accordion',
			'title'        => esc_html__( 'Text', 'colormag' ),
			'section'      => 'colormag_top_bar_section',
			'sub_controls' => apply_filters(
				'colormag_top_bar_text_sub_controls',
				array(
					'colormag_top_bar_text_color' => array(
						'default'   => '#555',
						'type'      => 'customind-color',
						'title'     => esc_html__( 'Color', 'colormag' ),
						'transport' => 'postMessage',
						'section'   => 'colormag_top_bar_section',
					),
				)
			),
			'collapsible'  => apply_filters( 'colormag_top_bar_text_accordion_collapsible', false ),
			'condition'    => array(
				'colormag_enable_top_bar' => true,
			),
		),
		'colormag_top_bar_label_heading'        => array(
			'type'         => 'customind-accordion',
			'title'        => esc_html__( 'Label', 'colormag' ),
			'section'      => 'colormag_top_bar_section',
			'sub_controls' => apply_filters(
				'colormag_top_bar_label_sub_controls',
				array(
					'colormag_top_bar_label_color' => array(
						'default'   => '#555',
						'type'      => 'customind-color',
						'title'     => esc_html__( 'Color', 'colormag' ),
						'transport' => 'postMessage',
						'section'   => 'colormag_top_bar_section',
					),
				)
			),
			'collapsible'  => apply_filters( 'colormag_top_bar_label_accordion_collapsible', false ),
			'condition'    => array(
				'colormag_enable_top_bar' => true,
			),
		),
		'colormag_top_bar_links_heading'        => array(
			'type'         => 'customind-accordion',
			'title'        => esc_html__( 'Links', 'colormag' ),
			'section'      => 'colormag_top_bar_section',
			'sub_controls' => apply_filters(
				'colormag_top_bar_links_sub_controls',
				array(
					'colormag_top_bar_link_color_group' => array(
						'type'         => 'customind-color-group',
						'title'        => esc_html__( 'Color', 'colormag' ),
						'section'      => 'colormag_top_bar_section',
						'sub_controls' => apply_filters(
							'colormag_top_bar_link_color_controls',
							array(
								'colormag_top_bar_link_color' => array(
									'default'   => 'var(--cm-color-1)',
									'type'      => 'customind-color',
									'title'     => esc_html__( 'Normal', 'colormag' ),
									'transport' => 'postMessage',
									'section'   => 'colormag_top_bar_section',
								),
								'colormag_top_bar_link_hover_color' => array(
									'default'   => '',
									'type'      => 'customind-color',
									'title'     => esc_html__( 'Link Color', 'colormag' ),
									'transport' => 'postMessage',
									'section'   => 'colormag_top_bar_section',
								),
							)
						),
					),
				)
			),
			'collapsible'  => apply_filters( 'colormag_top_bar_links_accordion_collapsible', false ),
			'condition'    => array(
				'colormag_enable_top_bar' => true,
			),
		),
	)
);

colormag_customind()->add_controls( $options );
