<?php
/**
 * Site branding template file.
 *
 * @package ColorMag
 *
 * TODO: @since.
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$screen_reader        = '';
$site_identity_enable = get_theme_mod( 'colormag_footer_enable_site_identity', true );
$site_tagline_enable  = get_theme_mod( 'colormag_footer_enable_site_tagline', true );
$footer_logo          = get_theme_mod( 'colormag_footer_logo', '' );
$footer_logo_url      = wp_get_attachment_url( $footer_logo );
$footer_site_title    = get_theme_mod( 'colormag_footer_site_title', '' );
$footer_site_tagline  = get_theme_mod( 'colormag_footer_site_tagline', '' );


?>
<div>
<?php if ( $footer_logo_url ) : ?>
	<div class="cm-footer-logo">
		<img src="<?php echo esc_url( $footer_logo_url ); ?>">
	</div><!-- #cm-site-branding -->
<?php endif; ?>

<?php

if ( $site_identity_enable || $site_tagline_enable ) {
	?>
	<div id="cm-site-info" class="cm-footer-site-info">
		<?php
		if ( $site_identity_enable ) {
			?>
			<h3 class="cm-footer-site-title <?php echo esc_attr( false === $site_identity_enable ? $screen_reader : '' ); ?>">
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( $footer_site_title ); ?>" rel="home"><?php echo esc_html( $footer_site_title ); ?></a>
			</h3>
			<?php
		}
		?>

		<?php
		if ( $site_tagline_enable ) {
			if ( $footer_site_tagline || is_customize_preview() ) :
				?>
				<p class="cm-footer-tagline <?php echo esc_attr( false === $site_tagline_enable ? $screen_reader : '' ); ?>">
					<?php echo esc_html( $footer_site_tagline ); ?>
				</p><!-- .cm-site-description -->
				<?php
			endif;
		}
		?>
	</div><!-- #cm-site-info -->
	<?php
}
?>
</div>
<?php
