<?php
$container_layout_choices = apply_filters(
	'colormag_container_layout_choices',
	array(
		'default'                      => array(
			'label' => 'Inherit',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/inherit.svg',
		),
		'no_sidebar_full_width'        => array(
			'label' => 'Normal',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/normal.svg',
		),
		'no_sidebar_content_centered'  => array(
			'label' => 'Narrow',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/narrow.svg',
		),
		'no_sidebar_content_stretched' => array(
			'label' => 'Full Width',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/full-width.svg',
		),
	)
);

$sidebar_layout_choices = apply_filters(
	'colormag_site_layout_choices',
	array(
		'default'       => array(
			'label' => 'Inherit',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/inherit.svg',
		),
		'no_sidebar'    => array(
			'label' => 'No Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/no-sidebar.svg',
		),
		'right_sidebar' => array(
			'label' => 'Right Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/right-sidebar.svg',
		),
		'left_sidebar'  => array(
			'label' => 'Left Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/left-sidebar.svg',
		),
		'two_sidebars'  => array(
			'label' => 'Both Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/both-sidebar.svg',
		),
	)
);
$options                = array(
	'colormag_single_page_container_tab_group'    => array(
		'type'    => 'customind-tabs',
		'title'   => esc_html__( 'Single Page', 'colormag' ),
		'section' => 'colormag_page_section',
		'tabs'    => array(
			'general' => esc_html__( 'General', 'colormag' ),
			'style'   => esc_html__( 'Style', 'colormag' ),
		),
		'default' => 'general',
	),
	'colormag_single_page_container_layout'       => array(
		'default'   => 'default',
		'type'      => 'customind-radio-image',
		'title'     => esc_html__( 'Container Layout', 'colormag' ),
		'section'   => 'colormag_page_section',
		'tab_group' => 'colormag_single_page_container_tab_group',
		'tab'       => 'general',
		'choices'   => $container_layout_choices,
		'columns'   => 2,
		'priority'  => 10,
	),
	'colormag_single_page_sidebar_layout_divider' => array(
		'type'      => 'customind-divider',
		'variant'   => 'dashed',
		'tab'       => 'general',
		'tab_group' => 'colormag_single_page_container_tab_group',
		'section'   => 'colormag_page_section',
	),
	'colormag_single_page_sidebar_layout'         => array(
		'default'    => 'default',
		'type'       => 'customind-radio-image',
		'title'      => esc_html__( 'Sidebar Layout', 'colormag' ),
		'section'    => 'colormag_page_section',
		'tab'        => 'general',
		'tab_group'  => 'colormag_single_page_container_tab_group',
		'choices'    => $sidebar_layout_choices,
		'columns'    => 2,
		'priority'   => 10,
		'conditions' => array(
			'relation' => 'OR',
			'terms'    => array(
				// Simple condition
				array(
					'id'       => 'colormag_single_page_container_layout',
					'operator' => '===',
					'value'    => 'no_sidebar_full_width',
				),
				// Nested condition
				array(
					'relation' => 'AND',
					'terms'    => array(
						array(
							'id'       => 'colormag_single_page_container_layout',
							'operator' => '===',
							'value'    => 'default',
						),
						array(
							'id'       => 'colormag_global_container_layout',
							'operator' => '===',
							'value'    => 'no_sidebar_full_width',
						),
					),
				),
			),
		),
	),
	'colormag_archive_page_heading'               => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Page Header', 'colormag' ),
		'section'   => 'colormag_page_section',
		'tab'       => 'general',
		'tab_group' => 'colormag_single_page_container_tab_group',
	),
	'colormag_enable_page_header'                 => array(
		'title'     => esc_html__( 'Enable', 'colormag' ),
		'default'   => true,
		'type'      => 'customind-toggle',
		'section'   => 'colormag_page_section',
		'tab'       => 'general',
		'tab_group' => 'colormag_single_page_container_tab_group',
	),
	'colormag_page_featured_image_heading'        => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Featured Image', 'colormag' ),
		'section'   => 'colormag_page_section',
		'tab'       => 'general',
		'tab_group' => 'colormag_single_page_container_tab_group',
	),
	'colormag_enable_page_featured_image'         => array(
		'title'     => esc_html__( 'Enable', 'colormag' ),
		'default'   => false,
		'type'      => 'customind-toggle',
		'section'   => 'colormag_page_section',
		'transport' => 'refresh',
		'tab_group' => 'colormag_single_page_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_page_featured_image_size'           => array(
		'default'   => 'large',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Image Size', 'colormag' ),
		'section'   => 'colormag_page_section',
		'choices'   => colormag_get_image_sizes(),
		'tab'       => 'general',
		'tab_group' => 'colormag_single_page_container_tab_group',
		'condition' => array(
			'colormag_enable_page_featured_image' => true,
		),
	),
	'colormag_page_title_color'                   => array(
		'title'     => esc_html__( 'Page Title', 'colormag' ),
		'default'   => '#333333',
		'type'      => 'customind-color',
		'transport' => 'postMessage',
		'section'   => 'colormag_page_section',
		'tab'       => 'style',
		'tab_group' => 'colormag_single_page_container_tab_group',
	),
	'colormag_page_title_typography'              => array(
		'default'   => array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'subsets'        => array( 'latin' ),
			'font-size'      => array(
				'desktop' => array(
					'size' => '34',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => 'px',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => 'px',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.6',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '-',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '-',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		),
		'type'      => 'customind-typography',
		'transport' => 'postMessage',
		'tab'       => 'style',
		'tab_group' => 'colormag_single_page_container_tab_group',
		'title'     => esc_html__( 'Post Title Font', 'colormag' ),
		'section'   => 'colormag_page_section',
	),
);

colormag_customind()->add_controls( $options );
