<?php
$container_layout_choices = apply_filters(
	'colormag_container_layout_choices',
	array(
		'no_sidebar_full_width'        => array(
			'label' => 'Normal',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/normal.svg',
		),
		'no_sidebar_content_centered'  => array(
			'label' => 'Narrow',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/narrow.svg',
		),
		'no_sidebar_content_stretched' => array(
			'label' => 'Full Width',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/full-width.svg',
		),
	)
);

$sidebar_layout_choices = apply_filters(
	'colormag_sidebar_layout_choices',
	array(
		'no_sidebar'    => array(
			'label' => 'No Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/no-sidebar.svg',
		),
		'right_sidebar' => array(
			'label' => 'Right Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/right-sidebar.svg',
		),
		'left_sidebar'  => array(
			'label' => 'Left Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/left-sidebar.svg',
		),
		'two_sidebars'  => array(
			'label' => 'Both Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/both-sidebar.svg',
		),
	)
);

$options = array(
	'colormag_layout_heading'          => array(
		'type'    => 'customind-heading',
		'title'   => esc_html__( 'Container', 'colormag' ),
		'section' => 'colormag_global_layout_section',
	),
	'colormag_global_container_layout' => array(
		'default' => 'no_sidebar_full_width',
		'type'    => 'customind-radio-image',
		'title'   => esc_html__( 'Layout', 'colormag' ),
		'section' => 'colormag_global_layout_section',
		'choices' => $container_layout_choices,
		'columns' => 2,
	),
	'colormag_container_layout'        => [
		'type'    => 'customind-toggle-button',
		'default' => 'wide',
		'title'   => esc_html__( 'Style', 'colormag' ),
		'section' => 'colormag_global_layout_section',
		'choices' => [
			'wide'  => esc_html__( 'Wide', 'colormag' ),
			'boxed' => esc_html__( 'Boxed', 'colormag' ),
		],
	],
	'colormag_container_width'         => array(
		'default'     => array(
			'size' => 1140,
			'unit' => 'px',
		),
		'type'        => 'customind-slider',
		'title'       => esc_html__( 'Width', 'colormag' ),
		'section'     => 'colormag_global_layout_section',
		'transport'   => 'postMessage',
		'units'       => array( 'px' ),
		'input_attrs' => array(
			'min'  => 768,
			'max'  => 1920,
			'step' => 1,
		),
	),
	'colormag_content_area_padding'    => array(
		'default'     => array(
			'top'    => '60',
			'right'  => '',
			'bottom' => '60',
			'left'   => '',
			'unit'   => 'px',
		),
		'type'        => 'customind-dimensions',
		'title'       => esc_html__( 'Padding', 'colormag' ),
		'section'     => 'colormag_global_layout_section',
		'units'       => array( 'px', 'em' ),
		'defaultUnit' => 'px',
	),
	'colormag_sidebar_heading'         => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Sidebar', 'colormag' ),
		'section'   => 'colormag_global_layout_section',
		'condition' => array(
			'colormag_global_container_layout' => 'no_sidebar_full_width',
		),
	),
	'colormag_global_sidebar_layout'   => array(
		'default'   => 'no_sidebar',
		'type'      => 'customind-radio-image',
		'title'     => esc_html__( 'Layout', 'colormag' ),
		'section'   => 'colormag_global_layout_section',
		'choices'   => $sidebar_layout_choices,
		'columns'   => 2,
		'condition' => array(
			'colormag_global_container_layout' => 'no_sidebar_full_width',
		),
	),
	'colormag_sidebar_width'           => array(
		'title'       => esc_html__( 'Width', 'colormag' ),
		'default'     => array(
			'size' => 30,
			'unit' => '%',
		),
		'type'        => 'customind-slider',
		'section'     => 'colormag_global_layout_section',
		'units'       => array( '%' ),
		'defaultUnit' => '%',
		'input_attrs' => array(
			'min'  => 15,
			'max'  => 80,
			'step' => 1,
		),
		'conditions'  => array(
			'relation' => 'OR',
			'terms'    => array(
				array(
					'id'       => 'colormag_global_sidebar_layout',
					'operator' => '===',
					'value'    => 'right_sidebar',
				),
				array(
					'id'       => 'colormag_global_sidebar_layout',
					'operator' => '===',
					'value'    => 'both_sidebars',
				),
			),
		),
	),
	'colormag_left_sidebar_width'      => array(
		'title'       => esc_html__( 'Left Sidebar Width', 'colormag' ),
		'default'     => array(
			'size' => 30,
			'unit' => '%',
		),
		'type'        => 'customind-slider',
		'section'     => 'colormag_global_layout_section',
		'units'       => array( '%' ),
		'defaultUnit' => '%',
		'conditions'  => array(
			'relation' => 'OR',
			'terms'    => array(
				array(
					'id'       => 'colormag_global_sidebar_layout',
					'operator' => '===',
					'value'    => 'left_sidebar',
				),
				array(
					'id'       => 'colormag_global_sidebar_layout',
					'operator' => '===',
					'value'    => 'both_sidebars',
				),
			),
		),
		'input_attrs' => array(
			'min'  => 15,
			'max'  => 80,
			'step' => 1,
		),
	),
	'colormag_enable_sticky_sidebar'   => array(
		'title'      => esc_html__( 'Sticky Sidebar', 'colormag' ),
		'default'    => false,
		'type'       => 'customind-toggle',
		'section'    => 'colormag_global_layout_section',
		'conditions' => array(
			'relation' => 'OR',
			'terms'    => array(
				array(
					'id'       => 'colormag_global_sidebar_layout',
					'operator' => '===',
					'value'    => 'left_sidebar',
				),
				array(
					'id'       => 'colormag_global_sidebar_layout',
					'operator' => '===',
					'value'    => 'right_sidebar',
				),
				array(
					'id'       => 'colormag_global_sidebar_layout',
					'operator' => '===',
					'value'    => 'both_sidebars',
				),
			),
		),
	),
	'colormag_demo_migrated_heading'   => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Demo Migrated', 'colormag' ),
		'section'      => 'colormag_global_layout_section',
		'sub_controls' => apply_filters(
			'colormag_demo_migrated_sub_controls',
			array(
				'demo_migrated_to_builder' => array(
					'default' => 0,
					'title'   => esc_html__( 'Demo migrated', 'colormag' ),
					'type'    => 'customind-toggle',
					'section' => 'colormag_global_layout_section',
				),
			),
		),
		'collapsible'  => apply_filters( 'colormag_demo_migrated_accordion_collapsible', false ),
	),
);

colormag_customind()->add_controls( $options );
