import { TabPanel } from '@wordpress/components';
import { __ } from '@wordpress/i18n';
import React from 'react';
import { useForm } from 'react-hook-form';
import useLocalStorage from '../../hook/useLocalStorage';
import { localized } from '../../utils/global';
import { ActivationForm } from './ActivationForm';
import { AccountDetails } from './components/AccountDetails';
import { Billing } from './components/Billing';

export const License = () => {
	const form = useForm({
		defaultValues: {},
	});
	const [isCollapsed, setIsCollapsed] = useLocalStorage<boolean>({
		key: '_cm_fs_nav_collapsed',
		defaultValue: false,
	});
	if (!localized?.fs?.activated) {
		return <ActivationForm />;
	}

	return (
		<>
			<TabPanel
				style={{ marginTop: '1rem' }}
				className="cm-setting-tab [&>div]:transition-none border border-solid border-[#E1E1E1] h-auto"
				onSelect={() => {}}
				tabs={[
					{
						name: 'account',
						title: __('Account', 'colormag'),
						className: 'cm-tabpanel_account',
					},
					{
						name: 'billing',
						title: __('Billing', 'colormag'),
						className: 'cm-mega-menu-tabpanel_billing',
					},
				]}
			>
				{(tab) => {
					return (
						<>
							<div
								className={`${tab.name === 'account' ? 'block' : 'hidden'} p-6`}
							>
								<AccountDetails />
							</div>
							<div
								className={`${tab.name === 'billing' ? 'block' : 'hidden'} p-6`}
							>
								<Billing />
							</div>
						</>
					);
				}}
			</TabPanel>
		</>
	);
};
