<?php
	$filter_object = new \TUTOR\Course_Filter();
	$filter_levels = array(
	  	'beginner'=> esc_html__('Beginner', 'wellearn'),
	  	'intermediate'=> esc_html__('Intermediate', 'wellearn'),
	  	'expert'=> esc_html__('Expert', 'wellearn')
	);
	$filter_prices=array(
		'free'=> esc_html__('Free', 'wellearn'),
		'paid'=> esc_html__('Paid', 'wellearn')
	);

	$supported_filters = tutor_utils()->get_option('supported_course_filters', array());
	$supported_filters = array_keys($supported_filters);
	$is_membership = get_tutor_option('monetize_by')=='pmpro' && tutils()->has_pmpro();

	$number = 0;
	$number = in_array('search', $supported_filters) ? $number + 1 : $number;
	$number = in_array('category', $supported_filters) ? $number + 1 : $number;
	$number = in_array('tag', $supported_filters) ? $number + 1 : $number;
	$number = in_array('difficulty_level', $supported_filters) ? $number + 1 : $number;
	$number = !$is_membership && in_array('price_type', $supported_filters) ? $number + 1 : $number;

	$filter_style = wellearn_get_option('course_filter_style', 'filter-dropdow');
	$filter_layout = wellearn_get_option('course_filter_layout', 'filter-layout-top');
	$filter_style = ($filter_layout == 'filter-layout-top') ? 'filter-dropdow' : $filter_style;

?>
<div class="tutor-course-filter" tutor-course-filter="">
<form class="course-filter-form search-cols-<?php echo esc_attr($number) ?> select-<?php echo esc_attr($filter_style) ?>">  
	
	<?php do_action('tutor_course_filter/before'); ?>
	
	<?php if(in_array('search', $supported_filters)){ ?>
		<div class="course-filter_search">
			<div class="input-wrap">
				<div class="input-icon"><i class="fa-solid fa-magnifying-glass"></i></div>
					<div class="input-content">
					<label class="title-field">
						<i class="fa-solid fa-magnifying-glass hidden"></i>
						<label class="title-field"><?php echo esc_html__('Keyword', 'wellearn'); ?></label>
					</label>
						<input type="text" name="keyword" placeholder="<?php echo esc_attr__('Search...', 'wellearn'); ?>"/>
						<i class="tutor-icon-magnifying-glass-1"></i>
				</div>	
			</div>	
		</div>
	<?php } ?>


	<?php if(in_array('category', $supported_filters)){ ?>
		<div class="course-filter_category course-checkbox-filter">
			<div class="input-wrap">
				<div class="input-icon"><i class="fa-solid fa-list"></i></div>
				<div class="input-content">
					<label class="title-field">
						<i class="fa-solid fa-list hidden"></i>
						<?php echo esc_html__('Category', 'wellearn'); ?>
					</label>
					<div class="show-results" data-placehoder="<?php echo esc_attr__('All Category', 'wellearn') ?>">
						<div class="content-inner"><?php echo esc_html__('All Category', 'wellearn') ?></div>
					</div>
					<div class="checkbox-filter-content">
						<ul class="content-inner">
							<?php $filter_object->render_terms('category'); ?>
						</ul>	
					</div>
				</div>
			</div>			
		</div>
	<?php } ?>

	<?php if(in_array('tag', $supported_filters)){ ?>
		<div class="course-filter_tag course-checkbox-filter">
			<div class="input-wrap">
				<div class="input-icon"><i class="fa-solid fa-tags"></i></div>
				<div class="input-content">
					<label class="title-field">
						<i class="fa-solid fa-tags hidden"></i>
						<?php echo esc_html__('Tag', 'wellearn'); ?>
					</label>
					<div class="show-results" data-placehoder="<?php echo esc_attr__('All Tags', 'wellearn') ?>">
						<div class="content-inner"><?php echo esc_html__('All Tags', 'wellearn') ?></div>
					</div>
					<div class="checkbox-filter-content">
						<ul class="content-inner">
							<?php $filter_object->render_terms('tag'); ?>
						</ul>	
					</div>
				</div>	
			</div>	
		</div>
	<?php } ?>


	<?php if(in_array('difficulty_level', $supported_filters)){ ?>
		<div class="course-filter_level course-checkbox-filter">
			<div class="input-wrap">
				<div class="input-icon"><i class="fa-solid fa-layer-group"></i></div>
				<div class="input-content">
					<label class="title-field">
						<i class="fa-solid fa-layer-group hidden"></i>
						<?php echo esc_html__('Level', 'wellearn'); ?>
					</label>
					<div class="show-results" data-placehoder="<?php echo esc_attr__('All Level', 'wellearn') ?>">
						<div class="content-inner"><?php echo esc_html__('All Level', 'wellearn') ?></div>
					</div>
					<div class="checkbox-filter-content">
						<ul class="content-inner">
							<?php foreach($filter_levels as $value => $title){ ?>
								<li class="tutor-list-item">
								  	<label>
										<input type="checkbox" class="tutor-form-check-input" name="tutor-course-filter-level" value="<?php echo esc_attr($value); ?>"/>
										<?php echo esc_html($title); ?>
								  	</label>
								</li>
						 	<?php } ?>
						</ul>
					</div>	 	
				</div>	
			</div>	
		</div>
	<?php } ?>

	<?php if(!$is_membership && in_array('price_type', $supported_filters)){ ?>
		<div class="course-filter-price_type course-checkbox-filter">
			<div class="input-wrap">
				<div class="input-icon"><i class="fa-solid fa-money-bill-wave"></i></div>
				<div class="input-content">
					<label class="title-field">
						<i class="fa-solid fa-money-bill-wave hidden"></i>
						<?php _e('Price', 'wellearn'); ?>
					</label>
					<div class="show-results" data-placehoder="<?php echo esc_attr__('Price', 'wellearn'); ?>">
						<div class="content-inner"><?php echo esc_html__('Price', 'wellearn'); ?></div>
					</div>
					<div class="checkbox-filter-content">
						<ul class="content-inner">
							<?php foreach($filter_prices as $value=>$title){ ?>
								<li class="tutor-list-item">
								  	<label>
										<input type="checkbox" class="tutor-form-check-input" name="tutor-course-filter-price" value="<?php echo esc_attr($value); ?>"/>
										<?php echo esc_html($title); ?>
								  	</label>
								</li>
						 	<?php } ?>
						</ul>
					</div>	
				</div>
			</div>		 	
		</div>

	<?php } ?>
			
	<input type="hidden" name="course_column_lg" value="<?php echo esc_attr(wellearn_get_option('course_column_lg', '3')) ?>" />
	<input type="hidden" name="course_column_md" value="<?php echo esc_attr(wellearn_get_option('course_column_md', '2')) ?>" />
	<input type="hidden" name="course_column_sm" value="<?php echo esc_attr(wellearn_get_option('course_column_sm', '2')) ?>" />
	<input type="hidden" name="course_column_xs" value="<?php echo esc_attr(wellearn_get_option('course_column_xs', '1')) ?>" />

	<div class="tutor-clear-all-filter">
		<a href="#" onclick="window.location.reload()">
			<i class="tutor-icon-cross"></i> 
			<span><?php echo esc_html__('Clear All Filter', 'wellearn') ?></span>
		</a>
	</div>
	<?php do_action('tutor_course_filter/after'); ?>
</form>
</div>
<?php if(is_active_sidebar('archive_course_sidebar')){ ?>
	<div class="archive-course-sidebar">
		<?php dynamic_sidebar('archive_course_sidebar'); ?>
	</div>
<?php } ?>