<?php
/**
   * @package TutorLMS/Templates
   * @version 1.4.3
*/

global $post, $authordata;

$course_id = get_the_ID();
$course_duration = get_tutor_course_duration_context();

?>

<div class="course-loop-footer">
   <div class="content-inner">
      <?php tutor_load_template( 'loop.course-price' ); ?>
      <div class="course-action">
         <?php 
            if(tutor_utils()->is_course_added_to_cart(get_the_ID())){
               tutor_load_template( 'loop.course-in-cart' );
            }
            else if(tutor_utils()->is_enrolled(get_the_ID())){
               tutor_load_template( 'loop.course-continue' );
            }
            else if( tutor_utils()->is_course_purchasable() ) {
               $enroll_btn = tutor_course_loop_add_to_cart(false);
               $product_id = tutor_utils()->get_course_product_id($course_id);
               $product    = wc_get_product( $product_id );

               if ( $product ) {
                  $btn_html = apply_filters( 'tutor_course_restrict_new_entry', $enroll_btn );
               }
               echo html_entity_decode($btn_html);
            }else{
               $btn_html = '<div class="tutor-loop-cart-btn-wrap">' . apply_filters( 'tutor_course_restrict_new_entry', '<a class="btn-purchase" href="'. get_the_permalink(). '">'.esc_html__('Get Enrolled', 'wellearn'). '</a>' ) . '</div>';
               echo html_entity_decode($btn_html);
            }
         ?>
      </div>   

   </div>


<?php if(!empty($course_duration)) { ?>
         <div class="loop-footer-item hidden coruse-duration">
            <span><i class="far fa-clock"></i><?php echo html_entity_decode($course_duration); ?></span>
         </div>
      <?php } ?>
      <div class="loop-footer-item course-loop-level hidden">
         <span><i class="far fa-flag"></i><?php echo get_tutor_course_level() ?></span>
      </div>
</div>
