<?php 
   if(!isset($index)){
      $index = 2;
   }
   $thumbnail = (isset($thumbnail_size) && $thumbnail_size) ? $thumbnail_size : 'wellearn_medium';
   if(!isset($excerpt_words)){
      $excerpt_words = wellearn_get_option('blog_excerpt_limit', 20);
   }
   $desc = wellearn_limit_words($excerpt_words, get_the_excerpt(), '');
?>

<article id="post-<?php echo esc_attr(get_the_ID()); ?>" class="post post-four__single">
   <div class="post-four__wrap">
      <div class="post-four__thumbnail">
         <a href="<?php echo esc_url( get_permalink() ) ?>">
            <?php the_post_thumbnail( $thumbnail, array( 'alt' => get_the_title() ) ); ?>
         </a>
         <div class="post-four__entry-date">
            <span class="date"><?php echo esc_html( get_the_date('d')) ?></span>
            <span class="month"><?php echo esc_html( get_the_date('M')) ?></span>
         </div>
      </div>
      <div class="post-four__content">
         <div class="post-four__meta">
            <?php wellearn_posted_on(); ?>
         </div> 
         <h2 class="post-four__title"><a href="<?php echo esc_url( get_permalink() ) ?>" rel="bookmark"><?php the_title() ?></a></h2>
         <?php if($desc){ ?>
            <div class="post-four__desc">
               <?php echo esc_html($desc) ?>
            </div>   
         <?php } ?>
         <a class="post-four__read-more btn-inline-theme" href="<?php echo esc_url( get_permalink() ) ?>">
            <span><?php echo esc_html__('Read More', 'wellearn'); ?></span>
         </a>
      </div>
   </div>
</article> 

  