<?php
/**
 * A single course loop rating
 *
 * @since v.1.0.0
 * @author themeum
 * @url https://themeum.com
 *
 * @package TutorLMS/Templates
 * @version 1.4.3
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$course_id = get_the_ID();

?>

<div class="tutor-rating-wishlist">
   <div class="tutor-loop-rating-wrap">
      <div class="content-inner">
   	<?php
      	$course_rating = tutor_utils()->get_course_rating();
      	tutor_utils()->star_rating_generator($course_rating->rating_avg);
      ?>
         <span class="tutor-rating-count">
            (<?php echo number_format($course_rating->rating_count); ?>)
         </span>
      </div>
   </div>
   <div class="course-wishlist">
      <?php
           $is_wishlisted = tutor_utils()->is_wishlisted($course_id);
           $has_wish_list = '';
           if ($is_wishlisted){
               $has_wish_list = 'has-wish-listed';
           }

           $action_class = '';
           if ( is_user_logged_in()){
               $action_class = apply_filters('tutor_wishlist_btn_class', 'tutor-course-wishlist-btn');
           }else{
               $action_class = apply_filters('tutor_popup_login_class', 'cart-required-login');
           }

         echo '<span class="tutor-course-wishlist">';
               echo '<a href="javascript:;" class="' . esc_attr($action_class) . ' ' . esc_attr($has_wish_list) . ' " data-course-id="' . esc_attr($course_id) . '"><i class="icon far fa-heart"></i></a>';
           echo '</span>';
      ?>
   </div>
</div>